<?php
/**
 *
 * Let's Review Admin Class
 *
 * @since      1.0.0
 *
 * @package    Let's Review
 * @subpackage lets-review/admin
 */

class Lets_Review_Admin {

	/**
	 * Var for Let's Review slug.
	 *
	 * @since    1.0.0
	 */
	private $slug;

	/**
	 * Var for Let's Review version.
	 *
	 * @since    1.0.0
	 */
	private $version;

	/**
	 * Var for Let's Review URL.
	 *
	 * @since    1.0.0
	 */
	private $url;

	/**
	 * Admin Constructor
	 *
	 * @since 1.0.0
	 *
	*/
	public function __construct( $slug, $version, $url ) {
		$this->slug    = $slug;
		$this->version = $version;
		$this->url     = $url;
		add_action( 'admin_enqueue_scripts', array( $this, 'lets_review_enqueue_scripts' ) );
		add_filter( 'display_post_states', array( $this, 'display_post_states' ), 10, 2 );
	}

	function display_post_states( $states = array(), $post = '' ) {
		if ( ! empty( $post->ID ) ) {
			if ( get_post_meta( $post->ID, '_lets_review_onoff', true ) == 1 ) {
				$states[] = 'Review';
			}
		}
		return $states;
	}

	/**
	 * Load Let's Review scripts for backend
	 *
	 * @since    1.0.0
	 */
	public function lets_review_enqueue_scripts( $pagenow ) {
		if ( is_customize_preview() ) {
			return;
		}
		if ( $pagenow == 'post.php' || $pagenow == 'post-new.php' || strpos( $pagenow, $this->slug ) !== false || $pagenow == 'widgets.php' ) {
			$ssl          = is_ssl() ? 'https' : 'http';
			$headings     = get_option( 'lets_review_gen_type_headings' );
			$font_heading = ( empty( $headings ) || $headings == 'none' ) ? '' : $headings;
			if ( ! empty( $font_heading ) ) {
				wp_enqueue_style( 'montserrat', esc_url( $ssl . '://fonts.googleapis.com/css?family=Montserrat:400,700' ) );
			}
			wp_enqueue_style( $this->slug, esc_url( $this->url . 'assets/admin/css/style.min.css' ), array(), $this->version, 'all' );
			wp_enqueue_style( 'codetipi-font', esc_url( $this->url . 'assets/fonts/codetipi/style.css' ), array(), $this->version, 'all' );

			if ( intval( get_option( 'lets_review_gen_fa' ) ) == 1 ) {
				wp_enqueue_style( 'font-awesome', $this->url . 'assets/fonts/fontawesome/css/fontawesome.min.css', array(), $this->version, 'all' );
				wp_enqueue_style( 'font-awesome-regular', $this->url . 'assets/fonts/fontawesome/css/regular.min.css', array(), $this->version, 'all' );
				wp_enqueue_style( 'font-awesome-solid', $this->url . 'assets/fonts/fontawesome/css/solid.min.css', array(), $this->version, 'all' );
			}

			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'jquery-ui-core' );
			wp_enqueue_script( 'jquery-ui-slider' );
			wp_enqueue_media();
			wp_enqueue_script( 'sol', $this->url . 'assets/admin/js/sol.min.js', array( 'jquery' ), $this->version, true );
			wp_enqueue_script( 'jquery-onoff', $this->url . 'assets/admin/js/jquery.onoff.min.js', array( 'jquery' ), $this->version, true );
			wp_enqueue_script( 'lr-js', $this->url . 'assets/admin/js/lets-review-admin.js', array( 'jquery', 'sol', 'jquery-onoff', 'jquery-ui-core', 'wp-color-picker' ), $this->version, true );
			wp_localize_script(
				'lr-js',
				'letsReview',
				array(
					'doubleDecimalStars' => apply_filters( 'lets_review_stars_double_decimal', 'off' ),
					'cbTitle'            => esc_html__( 'Title', 'lets-review' ),
					'cbScoreTitle'       => esc_html__( 'Score', 'lets-review' ),
					'cbAdd'              => esc_html__( 'Add', 'lets-review' ),
					'cbMediaButton'      => esc_html__( 'Insert', 'lets-review' ),
					'cbMediaSTitle'      => esc_html__( 'Select Image', 'lets-review' ),
					'cbMediaTitle'       => esc_html__( 'Select or Upload Images', 'lets-review' ),
					'cbUrlTitle'         => esc_html__( 'Affiliate URL', 'lets-review' ),
				)
			);
		}
	}
}
